/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.inventory;

import java.lang.reflect.Method;
import org.bukkit.block.Block;
import org.bukkit.block.EnchantingTable;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class CraftCustomContainer
extends CraftBlockState
implements InventoryHolder {
    protected final CraftWorld world;
    protected final tv inventory;

    public CraftCustomContainer(Block block) {
        super(block);
        this.world = (CraftWorld)block.getWorld();
        this.inventory = (tv)this.world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
    }

    public CraftCustomContainer(Block block, tv inventory) {
        super(block);
        this.world = (CraftWorld)block.getWorld();
        this.inventory = inventory;
    }

    @Override
    public Inventory getInventory() {
        return new CraftInventory(this.inventory);
    }

    public static class QuarkMatrixEnchantingTable
    extends CraftCustomContainer
    implements EnchantingTable {
        private static final boolean isEnable;
        private static Class<? extends avj> quarkTileMatrixEnchanterBaseClass;
        private static Method setCustomNameMethod;

        public static boolean isEnable() {
            return isEnable;
        }

        public static boolean isTileMatrixEnchanterBase(avj tileEntity) {
            return quarkTileMatrixEnchanterBaseClass.isInstance(tileEntity);
        }

        public QuarkMatrixEnchantingTable(Block block) {
            super(block);
            quarkTileMatrixEnchanterBaseClass.cast(this.inventory);
        }

        @Override
        public String getCustomName() {
            return this.inventory.n_() ? this.inventory.h_() : null;
        }

        @Override
        public Inventory getInventory() {
            return new CraftInventoryEnchanting(this.inventory);
        }

        @Override
        public void setCustomName(String name) {
            try {
                setCustomNameMethod.invoke((Object)this.inventory, name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            try {
                quarkTileMatrixEnchanterBaseClass = Class.forName("vazkii.quark.oddities.tile.TileMatrixEnchanterBase").asSubclass(avj.class);
                try {
                    setCustomNameMethod = quarkTileMatrixEnchanterBaseClass.getDeclaredMethod("func_145920_a", String.class);
                }
                catch (NoSuchMethodException e) {
                    setCustomNameMethod = quarkTileMatrixEnchanterBaseClass.getDeclaredMethod("setCustomName", String.class);
                }
                setCustomNameMethod.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            isEnable = quarkTileMatrixEnchanterBaseClass != null && setCustomNameMethod != null;
        }
    }
}

